<?php

$dal_info = array();

/**
 * User API function
 * @param String sql
 */
function UsersTableName()
{
	global $cman;
	$connection = $cman->getForLogin();
	return $connection->addTableWrappers("usuarios");
}

/**
 * User API function
 * It uses the default db connection
 * @param String dalSQL
 */
function CustomQuery($dalSQL)
{
	$connection = getDefaultConnection();
	$result = $connection->query( $dalSQL );
	if($result)
		return $result;
}

/**
 * User API function
 * It uses the default db connection 
 * @param String sql
 */
function DBLookup($sql)
{
	$connection = getDefaultConnection();
	$data = $connection->query( $sql )->fetchAssoc();

	if( $data )
		return reset($data);
	  
	return null;
}

/**
  * Data Access Layer.
  */
class tDAL
{
	var $tblnuevomarket_at_localhost__bancos;
	var $tblnuevomarket_at_localhost__carrito;
	var $tblnuevomarket_at_localhost__categorias;
	var $tblnuevomarket_at_localhost__configuracion;
	var $tblnuevomarket_at_localhost__delivery_select;
	var $tblnuevomarket_at_localhost__departamentos;
	var $tblnuevomarket_at_localhost__deseados;
	var $tblnuevomarket_at_localhost__fotos;
	var $tblnuevomarket_at_localhost__gramaje;
	var $tblnuevomarket_at_localhost__impuestos;
	var $tblnuevomarket_at_localhost__mails;
	var $tblnuevomarket_at_localhost__nuevomarke_tv90_searches;
	var $tblnuevomarket_at_localhost__nuevomarket_audit;
	var $tblnuevomarket_at_localhost__nuevomarket_uggroups;
	var $tblnuevomarket_at_localhost__nuevomarket_ugmembers;
	var $tblnuevomarket_at_localhost__nuevomarket_ugrights;
	var $tblnuevomarket_at_localhost__pagos;
	var $tblnuevomarket_at_localhost__pedidos;
	var $tblnuevomarket_at_localhost__productos;
	var $tblnuevomarket_at_localhost__tipo_envios;
	var $tblnuevomarket_at_localhost__tipo_moneda;
	var $tblnuevomarket_at_localhost__tipo_pagos;
	var $tblnuevomarket_at_localhost__usuarios;
	var $tblnuevomarket_at_localhost__visitas;
	var $tblnuevomarket_at_localhost__vistos;
	var $lstTables;
	var $Table = array();

	function FillTablesList()
	{
		if($this->lstTables)
			return;
		$this->lstTables[] = array("name" => "bancos", "varname" => "nuevomarket_at_localhost__bancos", "altvarname" => "bancos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "carrito", "varname" => "nuevomarket_at_localhost__carrito", "altvarname" => "carrito", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "categorias", "varname" => "nuevomarket_at_localhost__categorias", "altvarname" => "categorias", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "configuracion", "varname" => "nuevomarket_at_localhost__configuracion", "altvarname" => "configuracion", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "delivery_select", "varname" => "nuevomarket_at_localhost__delivery_select", "altvarname" => "delivery_select", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "departamentos", "varname" => "nuevomarket_at_localhost__departamentos", "altvarname" => "departamentos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "deseados", "varname" => "nuevomarket_at_localhost__deseados", "altvarname" => "deseados", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "fotos", "varname" => "nuevomarket_at_localhost__fotos", "altvarname" => "fotos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "gramaje", "varname" => "nuevomarket_at_localhost__gramaje", "altvarname" => "gramaje", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "impuestos", "varname" => "nuevomarket_at_localhost__impuestos", "altvarname" => "impuestos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "mails", "varname" => "nuevomarket_at_localhost__mails", "altvarname" => "mails", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "nuevomarke_tv90_searches", "varname" => "nuevomarket_at_localhost__nuevomarke_tv90_searches", "altvarname" => "nuevomarke_tv90_searches", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "nuevomarket_audit", "varname" => "nuevomarket_at_localhost__nuevomarket_audit", "altvarname" => "nuevomarket_audit", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "nuevomarket_uggroups", "varname" => "nuevomarket_at_localhost__nuevomarket_uggroups", "altvarname" => "nuevomarket_uggroups", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "nuevomarket_ugmembers", "varname" => "nuevomarket_at_localhost__nuevomarket_ugmembers", "altvarname" => "nuevomarket_ugmembers", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "nuevomarket_ugrights", "varname" => "nuevomarket_at_localhost__nuevomarket_ugrights", "altvarname" => "nuevomarket_ugrights", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "pagos", "varname" => "nuevomarket_at_localhost__pagos", "altvarname" => "pagos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "pedidos", "varname" => "nuevomarket_at_localhost__pedidos", "altvarname" => "pedidos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "productos", "varname" => "nuevomarket_at_localhost__productos", "altvarname" => "productos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "tipo_envios", "varname" => "nuevomarket_at_localhost__tipo_envios", "altvarname" => "tipo_envios", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "tipo_moneda", "varname" => "nuevomarket_at_localhost__tipo_moneda", "altvarname" => "tipo_moneda", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "tipo_pagos", "varname" => "nuevomarket_at_localhost__tipo_pagos", "altvarname" => "tipo_pagos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "usuarios", "varname" => "nuevomarket_at_localhost__usuarios", "altvarname" => "usuarios", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "visitas", "varname" => "nuevomarket_at_localhost__visitas", "altvarname" => "visitas", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
		$this->lstTables[] = array("name" => "vistos", "varname" => "nuevomarket_at_localhost__vistos", "altvarname" => "vistos", "connId" => "nuevomarket_at_localhost", "schema" => "", "connName" => "nuevomarket at localhost");
	}

	/**
      * Returns table object by table name.
      * @intellisense
      */
	function & Table($strTable, $schema = "", $connName = "")
	{
		$this->FillTablesList();
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper($strTable)==strtoupper($tbl["name"]) &&
				( schema == "" || strtoupper($schema) == strtoupper($tbl["schema"]) ) &&
				($connName == "" || strtoupper($connName) == strtoupper($tbl["connName"]) ) )
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
//	check table names without dbo. and other prefixes
		foreach($this->lstTables as $tbl)
		{
			if(strtoupper(cutprefix($strTable))==strtoupper(cutprefix($tbl["name"])))
			{
				$this->CreateClass($tbl);
				return $this->{"tbl".$tbl["varname"]};
			}
		}
		$dummy=null;
		return $dummy;
	}
	
	function CreateClass(&$tbl)
	{
		if($this->{"tbl".$tbl["varname"]})
			return;
//	load table info
		global $dal_info;
		include(getabspath("include/dal/".($tbl["varname"]).".php"));
//	create class and object

		$classname="class_".$tbl["varname"];
		$str = "class ".$classname." extends tDALTable  {";
		foreach($dal_info[$tbl["varname"]] as $fld)
		{
			$str.=' var $'.$fld["varname"].'; ';
		}
		
		$tableName = $tbl["name"];
		if( $tbl["schema"] )
			$tableName = $tbl["schema"] . "." . $tbl["name"];
		$str.=' function __construct()
			{
				$this->m_TableName = \''.escapesq( $tableName ).'\';
				$this->infoKey = \'' . $tbl["varname"] . '\';
				$this->setConnection('. $tbl["connId"] .');
			}
		};';
		eval($str);
		$this->{"tbl".$tbl["varname"]} = new $classname;
		$this->{$tbl["altvarname"]} = $this->{"tbl".$tbl["varname"]};
		$this->Table[$tbl["name"]]=&$this->{"tbl".$tbl["varname"]};
	}
	
	/**
      * Returns list of table names.
      * @intellisense
      */
	function GetTablesList()
	{
		$this->FillTablesList();
		$res=array();
		foreach($this->lstTables as $tbl)
			$res[]=$tbl["name"];
		return $res;
	}
	
	/**
      * Get list of table fields by table name.
      * @intellisense
      */
	function GetFieldsList($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldsList();
	}
	
	/**
      * Get field type by table name and field name.
      * @intellisense
      */
	function GetFieldType($table,$field)
	{
		$tbl = $this->Table($table);
		return $tbl->GetFieldType($field);
	}

	/**
      * Get table key fields by table name.
      * @intellisense
      */
	function GetDBTableKeys($table)
	{
		$tbl = $this->Table($table);
		return $tbl->GetDBTableKeys();
	}
}

$dal = new tDAL;

/**
 * Data Access Layer table class.
 */ 
class tDALTable
{
	var $m_TableName;
	var $infoKey;
	var $Param = array();
	var $Value = array();
	/**
	 * @type Connection
	 */
	var $_connection;
	
	/**
	 * Set the connection property
	 * @param String connId
	 */
	function setConnection( $connId )
	{
		global $cman;
		$this->_connection = $cman->byId( $connId );
	}
	
	/**
      * Get table key fields.
      * @intellisense
      */
	function GetDBTableKeys()
	{
		global $dal_info;
		if( !array_key_exists($this->infoKey, $dal_info) || !is_array($dal_info[ $this->infoKey ]) )
			return array();
		
		$ret = array();
		foreach($dal_info[ $this->infoKey ] as $fname=>$f)
		{
			if( @$f["key"] )
				$ret[] = $fname;
		}
		return $ret;
	}
	
	/**
      * Get list of table fields.
      * @intellisense
      */
	function GetFieldsList()
	{
		global $dal_info;
		return array_keys( $dal_info[ $this->infoKey ] );
	}

	/**
      * Get field type.
      * @intellisense
      */
	function GetFieldType($field)
	{
		global $dal_info;
		
		if( !array_key_exists( $field, $dal_info[ $this->infoKey ]) )
			return 200;
			
		return $dal_info[ $this->infoKey ][ $field ]["type"];
	}
	
	/**
	 *
	 */
	function PrepareValue($value, $type)
	{
		if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
		{
			if( IsBinaryType($type) )
			{
				if( $this->_connection->dbType == nDATABASE_Oracle )
					return "EMPTY_BLOB()";
					
				return "?";
			}
			
			if( $this->_connection->dbType == nDATABASE_Informix  && IsTextType($type) )
				return "?";
		}
	
		if( IsDateFieldType($type) )
		{
			if( !$value )
				return "null";
			else
				$this->_connection->addDateQuotes( $value );
		}
		
		if( NeedQuotes($type) )
			return $this->_connection->prepareString( $value );

		return 0 + $value;
	}
	
	/**
      * Get table name.
      * @intellisense
      */
	function TableName()
	{
		return $this->_connection->addTableWrappers( $this->m_TableName );
	} 

	/**
	 * @param Array blobs
	 * @param String dalSQL
	 * @param Array tableinfo
	 */
	protected function Execute_Query($blobs, $dalSQL, $tableinfo)
	{		
		$blobTypes = array();
		if( $this->_connection->dbType == nDATABASE_Informix )
		{		
			foreach( $blobs as $fname => $fvalue )
			{
				$blobTypes[ $fname ] = $tableinfo[ $fname ]["type"];
			}
		}

		$this->_connection->execWithBlobProcessing( $dalSQL, $blobs, $blobTypes );
	}

	/**
      * Add new record to the table.
      * @intellisense
      */
	function Add() 
	{
		global $dal_info;
		
		$insertFields = "";
		$insertValues = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		$blobs = array();
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Value[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Value as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$insertFields.= $this->_connection->addFieldWrappers( $fieldname ).",";
				$insertValues.= $this->PrepareValue($value,$fld["type"]) . ",";
				
				if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
				{
					if( IsBinaryType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
						
					if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )
						$blobs[ $fieldname ] = $value;
				}
				break;
			}
		}
		//	prepare and exec SQL
		if( $insertFields != "" && $insertValues != "" )		
		{
			$insertFields = substr($insertFields, 0, -1);
			$insertValues = substr($insertValues, 0, -1);
			$dalSQL = "insert into ".$this->_connection->addTableWrappers( $this->m_TableName )." (".$insertFields.") values (".$insertValues.")";
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}
		//	cleanup		
	    $this->Reset();
	}

	/**
      * Query all records from the table.
      * @intellisense
      */
	function QueryAll()
	{
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName );
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Do a custom query on the table.
      * @intellisense
      */
	function Query($swhere = "", $orderby = "")
	{
		if ($swhere)
			$swhere = " where ".$swhere;
			
		if ($orderby)
			$orderby = " order by ".$orderby;
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$swhere.$orderby;
		return $this->_connection->query( $dalSQL );
	}

	/**
      * Delete a record from the table.
      * @intellisense
      */
	function Delete()
	{
		global $dal_info;
		
		$deleteFields = "";
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			if( isset($this->{$fld['varname']}) )
			{
				$this->Param[ $fieldname ] = $this->{$fld['varname']};
			}
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$deleteFields.= $this->_connection->addFieldWrappers( $fieldname )."=". $this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		//	do delete
		if ($deleteFields)
		{
			$deleteFields = substr($deleteFields, 0, -5);
			$dalSQL = "delete from ".$this->_connection->addTableWrappers( $this->m_TableName )." where ".$deleteFields;
			$this->_connection->exec( $dalSQL );
		}
	
		//	cleanup
	    $this->Reset();
	}

	/**
      * Reset table object.
      * @intellisense
      */
	function Reset()
	{
		global $dal_info;
		
		$this->Value = array();
		$this->Param = array();
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		//	prepare parameters		
		foreach($tableinfo as $fieldname => $fld)
		{
			unset($this->{$fld["varname"]});
		}
	}	

	/**
      * Update record in the table.
      * @intellisense
      */
	function Update()
	{
		global $dal_info;
		
		$tableinfo = &$dal_info[ $this->infoKey ];
		$updateParam = "";
		$updateValue = "";
		$blobs = array();

		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			if( $fld["key"] )
				$command.= '$this->Param[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			else
				$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			if( !$fld["key"] && !array_key_exists( strtoupper($fieldname), array_change_key_case($this->Param, CASE_UPPER) ) )
			{
				foreach($this->Value as $field => $value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateValue.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . ", ";
					
					if( $this->_connection->dbType == nDATABASE_Oracle || $this->_connection->dbType == nDATABASE_DB2 || $this->_connection->dbType == nDATABASE_Informix )
					{
						if( IsBinaryType( $fld["type"] ) )
							$blobs[ $fieldname ] = $value;
							
						if( $this->_connection->dbType == nDATABASE_Informix && IsTextType( $fld["type"] ) )	
							$blobs[ $fieldname ] = $value;		
					}
					break;
				}
			}
			else
			{
				foreach($this->Param as $field=>$value)
				{
					if( strtoupper($field) != strtoupper($fieldname) )
						continue;
						
					$updateParam.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
					break;
				}
			}
		}

		//	construct SQL and do update	
		if ($updateParam)
			$updateParam = substr($updateParam, 0, -5);
		if ($updateValue)
			$updateValue = substr($updateValue, 0, -2);
			
		if ($updateValue && $updateParam)
		{
			$dalSQL = "update ".$this->_connection->addTableWrappers( $this->m_TableName )." set ".$updateValue." where ".$updateParam;
			$this->Execute_Query($blobs, $dalSQL, $tableinfo);
		}

		//	cleanup
		$this->Reset();
	}
	
	/**
	 * Select one or more records matching the condition
	 */
	function FetchByID()
	{
		global $dal_info;
		$tableinfo = &$dal_info[ $this->infoKey ];

		$dal_where = "";
		foreach($tableinfo as $fieldname => $fld)
		{
			$command = 'if(isset($this->'.$fld['varname'].')) { ';
			$command.= '$this->Value[\''.escapesq($fieldname).'\'] = $this->'.$fld['varname'].';';
			$command.= ' }';
			
			eval($command);
			
			foreach($this->Param as $field => $value)
			{
				if( strtoupper($field) != strtoupper($fieldname) )
					continue;
					
				$dal_where.= $this->_connection->addFieldWrappers( $fieldname )."=".$this->PrepareValue($value, $fld["type"]) . " and ";
				break;
			}
		}
		// cleanup
		$this->Reset();
		// construct and run SQL
		if ($dal_where)
			$dal_where = " where ".substr($dal_where, 0, -5);
			
		$dalSQL = "select * from ".$this->_connection->addTableWrappers( $this->m_TableName ).$dal_where;
		return $this->_connection->query( $dalSQL );
	}
}

function cutprefix($table)
{
	$pos = strpos($table,".");
	if( $pos === false )
		return $table;
		
	return substr($table, $pos + 1);
}

function escapesq($str)
{
	return str_replace(array("\\","'"),array("\\\\","\\'"),$str);
}

?>