<?php

/**
* getLookupMainTableSettings - tests whether the lookup link exists between the tables
*
*  returns array with ProjectSettings class for main table if the link exists in project settings.
*  returns NULL otherwise
*/
function getLookupMainTableSettings($lookupTable, $mainTableShortName, $mainField, $desiredPage = "")
{
	global $lookupTableLinks;
	if(!isset($lookupTableLinks[$lookupTable]))
		return null;
	if(!isset($lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField]))
		return null;
	$arr = &$lookupTableLinks[$lookupTable][$mainTableShortName.".".$mainField];
	$effectivePage = $desiredPage;
	if(!isset($arr[$effectivePage]))
	{
		$effectivePage = PAGE_EDIT;
		if(!isset($arr[$effectivePage]))
		{
			if($desiredPage == "" && 0 < count($arr))
			{
				$effectivePage = $arr[0];
			}
			else
				return null;
		}
	}
	return new ProjectSettings($arr[$effectivePage]["table"], $effectivePage);
}

/** 
* $lookupTableLinks array stores all lookup links between tables in the project
*/
function InitLookupLinks()
{
	global $lookupTableLinks;

	$lookupTableLinks = array();

	$lookupTableLinks["productos"]["carrito.producto"]["edit"] = array("table" => "carrito", "field" => "producto", "page" => "edit");
	$lookupTableLinks["gramaje"]["carrito.gramaje"]["edit"] = array("table" => "carrito", "field" => "gramaje", "page" => "edit");
	$lookupTableLinks["tipo_moneda"]["configuracion.moneda_activa"]["edit"] = array("table" => "configuracion", "field" => "moneda_activa", "page" => "edit");
	$lookupTableLinks["tipo_moneda"]["pagos.moneda"]["edit"] = array("table" => "pagos", "field" => "moneda", "page" => "edit");
	$lookupTableLinks["tipo_pagos"]["pagos.tipopago"]["edit"] = array("table" => "pagos", "field" => "tipopago", "page" => "edit");
	$lookupTableLinks["bancos"]["pagos.banco"]["edit"] = array("table" => "pagos", "field" => "banco", "page" => "edit");
	$lookupTableLinks["tipo_envios"]["pagos.tipo_envio"]["edit"] = array("table" => "pagos", "field" => "tipo_envio", "page" => "edit");
	$lookupTableLinks["configuracion"]["pedidos.tasa"]["edit"] = array("table" => "pedidos", "field" => "tasa", "page" => "edit");
	$lookupTableLinks["usuarios"]["pedidos.usuario"]["edit"] = array("table" => "pedidos", "field" => "usuario", "page" => "edit");
	$lookupTableLinks["tipo_moneda"]["pagos_manual.moneda"]["edit"] = array("table" => "pagos_manual", "field" => "moneda", "page" => "edit");
	$lookupTableLinks["tipo_pagos"]["pagos_manual.tipopago"]["edit"] = array("table" => "pagos_manual", "field" => "tipopago", "page" => "edit");
	$lookupTableLinks["bancos"]["pagos_manual.banco"]["edit"] = array("table" => "pagos_manual", "field" => "banco", "page" => "edit");
	$lookupTableLinks["departamentos"]["categorias.id_dpto"]["edit"] = array("table" => "categorias", "field" => "id_dpto", "page" => "edit");
	$lookupTableLinks["tipo_envios"]["delivery_select.delivery"]["edit"] = array("table" => "delivery_select", "field" => "delivery", "page" => "edit");
	$lookupTableLinks["departamentos"]["productos_master.departamento"]["edit"] = array("table" => "productos_master", "field" => "departamento", "page" => "edit");
	$lookupTableLinks["impuestos"]["productos_master.imp"]["edit"] = array("table" => "productos_master", "field" => "imp", "page" => "edit");
	$lookupTableLinks["categorias"]["productos_master.categoria"]["edit"] = array("table" => "productos_master", "field" => "categoria", "page" => "edit");
	$lookupTableLinks["productos"]["fotos1.producto"]["edit"] = array("table" => "fotos", "field" => "producto", "page" => "edit");
	$lookupTableLinks["departamentos"]["fotos1.departamento"]["edit"] = array("table" => "fotos", "field" => "departamento", "page" => "edit");
	$lookupTableLinks["categorias"]["fotos1.categoria"]["edit"] = array("table" => "fotos", "field" => "categoria", "page" => "edit");
}

?>